
library(data.table)
library(ggplot2)
library(metR)
library(RColorBrewer)

rm(list=ls())

## Create final file #

Other_pop <- read.csv ("./Average count/Average_otherpop_by building.csv")
Rebreathed_prop <- read.csv ("./Rebreathed air/Rebreathed proportion_by building.csv")
Results_Q <- read.csv("./Q results/Results_Q.csv")

mergedat <- merge(Other_pop, Rebreathed_prop, by = "Building")
fullmerge <- merge(mergedat, Results_Q, by = c("Building", "Type"))
fullmerge_final <- fullmerge[-c(3,5,6,9,10)]
write.csv(fullmerge_final, "./Final Results/Figure5data.csv")


Merged <- cbind(Other_pop, Rebreathed_prop)
Data.frame <- cbind(Merged, Results_Q)
Data <- Data.frame[-c(1,2,4,5,8,9,10,11,12)]
Data <- Data[c(2,7,1,3,4,5,6)]

write.csv(Data, "./Final Results/Final results_building.csv")


#### Final Plots ####
Results <- read.csv("./Final Results/Final results_building.csv")
Results2 <- read.csv("./Final Results/Figure5data.csv")


brks2 <- cut(Results2$Rebreathed,breaks=seq(0,13000,len=13))
brks2 <- gsub(","," - ",brks2,fixed=TRUE)
Results2$brks2 <- gsub("\\(|\\]","",brks2)  # reformat guide labels
names(Results2)[names(Results2) == "brks2"] <- "Rebreathed_range"
keep <- c("Building", "Type", "Other_pop","Q", "Rebreathed", "Rebreathed_range")
Results3 <- Results2[keep]
write.csv(Results3, "./Final Results/Figure5dat_bins.csv")


colourCount = length(unique(Results2$brks2))
getPalette = colorRampPalette(brewer.pal(9, "Set1"))
ggplot(Results2,aes(Other_pop,Q)) + 
  geom_point(fill="red") +
  geom_tile(aes(fill=brks2))+
  scale_fill_manual("Rebreathed Fraction",values=brewer.pal(10,"Set3"))
  #scale_x_continuous(expand=c(0,0))+
  #scale_y_continuous(expand=c(0,0))+
  #coord_fixed()

# Method for manual contour plot #
brks <- cut(Results$Q,breaks=seq(0,8000,len=100))
brks <- gsub(","," - ",brks,fixed=TRUE)
Results$Q <- gsub("\\(|\\]","",brks)  # reformat guide labels

ggplot(Results,aes(Other_pop,Q)) + 
  geom_tile(aes(fill=brks))+
  scale_fill_manual("Z",values=brewer.pal(13,"YlOrRd"))


# Other plots #
v <- ggplot(Results, aes(Other_pop, Rebreathed_other, z = Rebreathed))
v + geom_density_2d_filled(alpha = 1) +
  geom_density_2d(size = 0.25, colour = "black")

ggplot(Results, aes(Other_pop, Q, Z=Rebreathed)) +
  geom_point(fill="red") +
  stat_density_2d(aes(fill = ..level..), geom = "polygon", colour="white", size=0.25)
